IF OBJECT_ID('PDV_VD_NFCE_BKP_DATA_MIGRADO') IS NULL AND OBJECT_ID ('PDV_VD_NFCE_BKP_DATA') IS NOT NULL AND COL_LENGTH('PDV_VD_NFCE','CD_VD') IS NULL
BEGIN

	BEGIN TRAN

	BEGIN TRY
	
		INSERT INTO PDV_VD_NFCE
		(CD_EMP,CD_FILIAL,DT_VD,CD_CX,SERIE,NR_NF)
		SELECT	VD.CD_EMP,VD.CD_FILIAL,VD.DT_VD,VD.CD_CX, ISNULL(SUBSTRING(CHV_NFCE, 23,3), 1) ,VD.NR_ECF
		FROM	PDV_VD_NFCE_BKP_DATA NFCE_BKP 
		INNER JOIN	PDV_VD VD
		ON		VD.CD_EMP		= NFCE_BKP.CD_EMP
		AND		VD.CD_FILIAL	= NFCE_BKP.CD_FILIAL
		AND		VD.CD_VD		= NFCE_BKP.CD_VD

		INSERT INTO PDV_VD_PDV_VD_NFCE	
		(CD_EMP,CD_FILIAL,CD_VD,CD_NFCE)
		SELECT	VD.CD_EMP,VD.CD_FILIAL,VD.CD_VD,NFCE.CD_NFCE
		FROM	PDV_VD_NFCE NFCE 
		INNER	JOIN PDV_VD VD
		ON		VD.CD_EMP		= NFCE.CD_EMP
		AND		VD.CD_FILIAL	= NFCE.CD_FILIAL
		AND		VD.CD_CX		= NFCE.CD_CX
		AND		VD.DT_VD		= NFCE.DT_VD
		AND		VD.NR_ECF		= NFCE.NR_NF

		EXECUTE SP_RENAME 'PDV_VD_NFCE_BKP_DATA','PDV_VD_NFCE_BKP_DATA_MIGRADO'

		COMMIT TRAN

	END TRY

	BEGIN CATCH
		ROLLBACK TRAN

		DECLARE @ERROR_MSG NVARCHAR(4000)
		DECLARE @ERROR_SEVERITY INT
		DECLARE @ERROR_STATE INT

		SET @ERROR_MSG = ERROR_MESSAGE()
		SET @ERROR_SEVERITY = ERROR_SEVERITY()
		SET @ERROR_STATE = ERROR_STATE()

		RAISERROR(@ERROR_MSG,@ERROR_SEVERITY,@ERROR_STATE)

	END CATCH

END